<?php
use WHMCS\Database\Capsule;


if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define addon module configuration parameters.
 *
 * Includes a number of required system fields including name, description,
 * author, language and version.
 *
 * Also allows you to define any configuration parameters that should be
 * presented to the user when activating and configuring the module. These
 * values are then made available in all module function calls.
 *
 * Examples of each and their possible configuration parameters are provided in
 * the fields parameter below.
 *
 * @return array
 */
function digio_config()
{
    return [
        // Display name for your module 
        'name' => 'eKYC DIGIO',
        // Description displayed within the admin interface
        'description' => 'This module to help manage aadhar card verification by digio api',
        // Module author name
        'author' => 'Karam',
        // Default language
        'language' => 'english',
        // Version number
        'version' => '1.0',

    ];
}

/**
 * Activate.
 *
 * Called upon activation of the module for the first time.
 * Use this function to perform any database and schema modifications
 * required by your module.
 *
 * This function is optional.
 *
 * @see https://developers.whmcs.com/advanced/db-interaction/
 *
 * @return array Optional success/failure message
 */
function digio_activate()
{
    // Create custom tables and schema required by your module
    try {
        
        # Create DB Tables


    	Capsule::schema()->create(
            'mod_digio_settings',
            function ($table) {                    
                $table->increments('id');
                $table->string('clientid', 110)->nullable();                    
                $table->string('clientsecret', 110)->nullable();                    
                $table->string('apiurl', 50)->nullable();                    
                $table->string('status', 50)->nullable();                    
                $table->string('etc', 50)->nullable();                     
            }
        );

        Capsule::schema()->create(
            'mod_digio',
            function ($table) {                    
                $table->increments('id');
                $table->string('userid', 50)->nullable();                    
                $table->string('requestid', 100)->nullable();                    
                $table->string('created_at', 100)->nullable();                    
                $table->string('updated_at', 100)->nullable();                    
                $table->string('status', 50)->nullable();                    
                $table->string('reference_id', 100)->nullable();                    
                $table->string('transaction_id', 50)->nullable();                    
                $table->string('expire_in_days', 50)->nullable();                    
                $table->string('reminder_registered', 50)->nullable();                    
                $table->string('etc', 50)->nullable();                    
            }
        );

        

        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => '',
        ];

    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            'status' => "error",
            'description' => 'Unable to create mod_digio: ' . $e->getMessage(),
        ];
    }

}

/**
 * Deactivate.
 *
 * Called upon deactivation of the module.
 * Use this function to undo any database and schema modifications
 * performed by your module.
 *
 * This function is optional.
 *
 * @see https://developers.whmcs.com/advanced/db-interaction/
 *
 * @return array Optional success/failure message
 */
function digio_deactivate()
{
    // Undo any database and schema modifications made by your module here
    try {
        # Remove DB Tables
        Capsule::statement("DROP TABLE `mod_digio`");      

        Capsule::statement("DROP TABLE `mod_digio_settings`");      

        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => '',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            "status" => "error",
            "description" => "Unable to drop mod_digio: {$e->getMessage()}",
        ];
    }
}

/**
 * Upgrade.
 *
 * Called the first time the module is accessed following an update.
 * Use this function to perform any required database and schema modifications.
 *
 * This function is optional.
 *
 * @see https://laravel.com/docs/5.2/migrations
 *
 * @return void
 */
function digio_upgrade($vars)
{
    $currentlyInstalledVersion = $vars['version'];    
}

/**
 * Admin Area Output.
 *
 * Called when the addon module is accessed via the admin area.
 * Should return HTML output for display to the admin user.
 *
 * This function is optional.
 *
 * @see AddonModule\Admin\Controller::index()
 *
 * @return string
 */
function digio_output($vars)
{
    //echo "<pre>"; print_r($vars); die;
       
    // Get common module parameters
    $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
    $modulename = $vars['module']; // eg. addonmodules.php?module=addonmodule
    $version = $vars['version']; // eg. 1.0
    $_lang = $vars['_lang']; // an array of the currently loaded language variables

    
    include(__DIR__.'/dashboard.php');
    
}
?>